#include<stdio.h>
#include<stdlib.h>
#include<unistd.h>
#include<pthread.h>

#define S 10 // broj vozila iz jednog pravca
#define J 10 // broj vozila iz drugog pravca

#define AUTO 0
#define AUTOBUS 1
#define KAMION 2

pthread_mutex_t mutex = PTHREAD_MUTEX_INITIALIZER;
pthread_cond_t cond = PTHREAD_COND_INITIALIZER;

int naNadvoznjakuSever = 0; //broj vozila koja su trenutno na nadvoznjaku i krecu se sever->jug
int naNadvoznjakuJug = 0; //broj vozila koja su trenutno na nadvoznjaku i krecu se jug->sever

int brBus = 0; //flag da li se na nadvoznjaku trenutno nalazi autobus
int brKamion = 0; // flag da li se na nadvoznjaku trenutno nalazi kamion

void* fSever(void* arg)
{
    long id = (long)arg;

    int trenutak = rand() % 5;
    int tipVozila = rand() % 3;

    sleep(trenutak);
    switch(tipVozila) //ispis stiglih
    {
        case AUTOBUS:
            printf("Autobus %ld je stigao kod nadvoznjaka sa severa\n", id);
            break;
        case KAMION:
            printf("Kamion %ld je stigao kod nadvoznjaka sa severa\n", id);
            break;
        default:
            printf("Auto %ld je stigao kod nadvoznjaka sa severa\n", id);
            break;

    }
    
    pthread_mutex_lock(&mutex);

    while(naNadvoznjakuJug != 0 || (tipVozila == AUTOBUS && brBus != 0) || brKamion != 0 || (tipVozila == KAMION && naNadvoznjakuSever != 0)) 
    {
        // printf("Vozilo %ld mora da ceka jer ima vozila iz suprotnog smera\n", id);
        pthread_cond_wait(&cond, &mutex);
    }
    // while(tipVozila == AUTOBUS && brBus != 0)
    // {
    //     printf("Autobus %ld mora da ceka jer vec ima jedan bus na nadvoznjaku\n", id);
    //     pthread_cond_wait(&cond, &mutex);
    // }
    // while(brKamion != 0)
    // {
    //     printf("Vozilo %ld mora da ceka jer se na nadvoznjaku nalazi kamion\n", id);
    //     pthread_cond_wait(&cond, &mutex);
    // }

    naNadvoznjakuSever++;
    if(tipVozila == AUTOBUS)
        brBus++;
    if(tipVozila == KAMION)
        brKamion++;
    
    pthread_mutex_unlock(&mutex);

    switch(tipVozila) //ispis prelaska
    {
        case AUTOBUS:
            printf("Autobus %ld prelazi nadvoznjak\n", id);
            break;
        case KAMION:
            printf("Kamion %ld prelazi nadvoznjak\n", id);
            break;
        default:
            printf("Auto %ld prelazi nadvoznjak\n", id);
            break;

    }
    sleep(1);

    pthread_mutex_lock(&mutex);

    naNadvoznjakuSever--;
    if(tipVozila == AUTOBUS)
    {
        brBus--;
        if(brBus == 0 && naNadvoznjakuSever == 0) pthread_cond_broadcast(&cond);
    }
    else if(tipVozila == KAMION)
    {
        brKamion--;
        if(brKamion == 0) pthread_cond_broadcast(&cond);
    }
    else if(naNadvoznjakuSever == 0)
    {
        pthread_cond_broadcast(&cond);
    }
    
    pthread_mutex_unlock(&mutex);

    switch(tipVozila) //ispis proslih
    {
        case AUTOBUS:
            printf("Autobus %ld je presao nadvoznjak\n", id);
            break;
        case KAMION:
            printf("Kamion %ld je presao nadvoznjak\n", id);
            break;
        default:
            printf("Auto %ld je presao nadvoznjak\n", id);
            break;

    }
    pthread_exit(NULL);
}

void* fJug(void* arg)
{
    long id = (long)arg;

    int trenutak = rand() % 5;
    int tipVozila = rand() % 3;

    sleep(trenutak);

    switch(tipVozila) //ispis stiglih
    {
        case AUTOBUS:
            printf("Autobus %ld je stigao kod nadvoznjaka sa juga\n", id);
            break;
        case KAMION:
            printf("Kamion %ld je stigao kod nadvoznjaka sa juga\n", id);
            break;
        default:
            printf("Auto %ld je stigao kod nadvoznjaka sa juga\n", id);
            break;

    }
    
    pthread_mutex_lock(&mutex);
    
    while(naNadvoznjakuSever != 0 || (tipVozila == AUTOBUS && brBus != 0) || brKamion != 0 || (tipVozila == KAMION && naNadvoznjakuJug != 0)) 
    {
        // printf("Vozilo %ld mora da ceka jer ima vozila iz suprotnog smera\n", id);
        pthread_cond_wait(&cond, &mutex);
    }
    // while(tipVozila == AUTOBUS && brBus != 0)
    // {
    //     printf("Autobus %ld mora da ceka jer vec ima jedan bus na nadvoznjaku\n", id);
    //     pthread_cond_wait(&cond, &mutex);
    // }
    // while(brKamion != 0)
    // {
    //     printf("Vozilo %ld mora da ceka jer se na nadvoznjaku nalazi kamion\n", id);
    //     pthread_cond_wait(&cond, &mutex);
    // }

    naNadvoznjakuJug++;
    if(tipVozila == AUTOBUS)
        brBus++;
    if(tipVozila == KAMION)
        brKamion++;
    
    pthread_mutex_unlock(&mutex);

    switch(tipVozila) //ispis prelaska
    {
        case AUTOBUS:
            printf("Autobus %ld prelazi nadvoznjak\n", id);
            break;
        case KAMION:
            printf("Kamion %ld prelazi nadvoznjak\n", id);
            break;
        default:
            printf("Auto %ld prelazi nadvoznjak\n", id);
            break;

    }
    sleep(1);

    pthread_mutex_lock(&mutex);

    naNadvoznjakuJug--;
    if(tipVozila == AUTOBUS)
    {
        brBus--;
        if(brBus == 0) pthread_cond_broadcast(&cond);
    }
    else if(tipVozila == KAMION)
    {
        brKamion--;
        if(brKamion == 0) pthread_cond_broadcast(&cond);
    }
    else if(naNadvoznjakuJug == 0)
    {
        pthread_cond_broadcast(&cond);
    }
    
    pthread_mutex_unlock(&mutex);

    switch(tipVozila) //ispis proslih
    {
        case AUTOBUS:
            printf("Autobus %ld je presao nadvoznjak\n", id);
            break;
        case KAMION:
            printf("Kamion %ld je presao nadvoznjak\n", id);
            break;
        default:
            printf("Auto %ld je presao nadvoznjak\n", id);
            break;

    }
    
    pthread_exit(NULL);
}

int main()
{
    srand(time(NULL));
    pthread_t t[S+J];

    for(long i = 0;i < S; i++)
        pthread_create(t+i, NULL, fSever, (void*)i);

    for(long i = S;i < S+J; i++)
        pthread_create(t+i, NULL, fJug, (void*)i);

    for(int i=0;i<S+J;i++)
        pthread_join(t[i], NULL);
    
    return 0;
}
